StartupEvents.registry('fluid', function (event) {
    var register = function (name, color, temperature) {
        if (temperature === void 0) { temperature = 800; }
        var hex = color.startsWith('#') ? color.slice(1) : color;
        var r = parseInt(hex.substring(0, 2), 16);
        var g = parseInt(hex.substring(2, 4), 16);
        var b = parseInt(hex.substring(4, 6), 16);
        var colorObj = Color.rgba(r, g, b, 255);
        return event.create(name).thickTexture(colorObj).bucketColor(colorObj).temperature(temperature);
    };
    register('molten_fluix', '#9b5feb');
    register('molten_zanite', '#7539cc');
    register('molten_fiery', '#48271e', 1400);
    register('molten_brass', '#fce892');
    register('molten_scarlet_neodymium', '#b91919');
    register('molten_azure_neodymium', '#1936b9');
    register('molten_desh', '#d38b4c');
    register('molten_ostrum', '#a66b72');
    register('molten_calorite', '#c94d4e', 1400);
    register('molten_ironwood', '#817549');
    register('molten_iridium', '#d1ccc6', 1200);
});
