StartupEvents.registry('minecraft:item', function (event) {
    var registerTier1To4Ores = function (name, color) {
        var colorGetter = function () {
            var hex = color.startsWith('#') ? color.slice(1) : color;
            var r = parseInt(hex.substring(0, 2), 16);
            var g = parseInt(hex.substring(2, 4), 16);
            var b = parseInt(hex.substring(4, 6), 16);
            return Color.rgba(r, g, b, 255);
        };
        event.create("".concat(name, "_shard")).texture('mekanism:item/shard').color(0, colorGetter);
        event.create("".concat(name, "_clump")).texture('mekanism:item/clump').color(0, colorGetter);
        event.create("".concat(name, "_dirty_dust")).texture('mekanism:item/dirty_dust').color(0, colorGetter);
        event.create("".concat(name, "_dust")).texture('mekanism:item/dust').color(0, colorGetter);
    };
    registerTier1To4Ores('ironwood', '#9ca24d');
    registerTier1To4Ores('cobalt', '#0752b6');
    registerTier1To4Ores('titanium', '#e2e9e9');
    registerTier1To4Ores('stellarium', '#d1382e');
    registerTier1To4Ores('immersed_silver', '#55718c');
    registerTier1To4Ores('inert_witherium', '#48403c');
    registerTier1To4Ores('hothium', '#aecce6');
    registerTier1To4Ores('magiga', '#a191fc');
    registerTier1To4Ores('tonium', '#276e26');
    registerTier1To4Ores('scarlet_neodymium', '#b91919');
    registerTier1To4Ores('azure_neodymium', '#1936b9');
    registerTier1To4Ores('desh', '#c57041');
    registerTier1To4Ores('ostrum', '#76525f');
    registerTier1To4Ores('calorite', '#b63044');
});
