StartupEvents.registry('item', function (event) {
    var registerExtraTierOres = function (name, color) {
        var colorGetter = function () {
            var hex = color.startsWith('#') ? color.slice(1) : color;
            var r = parseInt(hex.substring(0, 2), 16);
            var g = parseInt(hex.substring(2, 4), 16);
            var b = parseInt(hex.substring(4, 6), 16);
            return Color.rgba(r, g, b, 255);
        };
        event.create("broken_".concat(name, "_shard")).texture('kubejs:item/broken_shard').color(0, colorGetter);
        event.create("tiny_".concat(name, "_shard")).texture('kubejs:item/tiny_shard').color(0, colorGetter);
        event.create("compressed_".concat(name, "_shard")).texture('kubejs:item/compressed_shard').color(0, colorGetter);
        event
            .create("recrystallized_".concat(name, "_crystal"))
            .texture('kubejs:item/recrystallized_crystal')
            .color(0, colorGetter);
        event.create("crystallized_".concat(name, "_shard")).texture('kubejs:item/crystallized_shard').color(0, colorGetter);
        event.create("crystallized_".concat(name, "_clump")).texture('kubejs:item/crystallized_clump').color(0, colorGetter);
        event.create("crystallized_".concat(name, "_crumb")).texture('kubejs:item/crystallized_crumb').color(0, colorGetter);
        event
            .create("dense_crystallized_".concat(name, "_plate"))
            .texture('kubejs:item/dense_crystallized_plate')
            .color(0, colorGetter);
        event
            .create("powered_crystallized_".concat(name, "_plate"))
            .texture('kubejs:item/powered_crystallized_plate')
            .color(0, colorGetter);
        event.create("".concat(name, "_crystal_fragment")).texture('kubejs:item/crystal_fragment').color(0, colorGetter);
        event
            .create("powered_".concat(name, "_crystal_fragment"))
            .texture('kubejs:item/powered_crystal_fragment')
            .color(0, colorGetter);
        event.create("crystallized_".concat(name, "_dust")).texture('kubejs:item/crystallized_dust').color(0, colorGetter);
        event
            .create("dense_".concat(name, "_crystal_fragment"))
            .texture('kubejs:item/dense_crystal_fragment')
            .color(0, colorGetter);
        event.create("dirty_".concat(name, "_smooth_dust")).texture('kubejs:item/dirty_smooth_dust').color(0, colorGetter);
        event.create("".concat(name, "_smooth_dust")).texture('kubejs:item/smooth_dust').color(0, colorGetter);
        event.create("sintered_".concat(name, "_dust")).texture('kubejs:item/sintered_dust').color(0, colorGetter);
    };
    registerExtraTierOres('ironwood', '#9ca24d');
    registerExtraTierOres('cobalt', '#0752b6');
    registerExtraTierOres('titanium', '#e2e9e9');
    registerExtraTierOres('stellarium', '#d1382e');
    registerExtraTierOres('immersed_silver', '#55718c');
    registerExtraTierOres('inert_witherium', '#48403c');
    registerExtraTierOres('hothium', '#aecce6');
    registerExtraTierOres('magiga', '#a191fc');
    registerExtraTierOres('tonium', '#276e26');
    registerExtraTierOres('scarlet_neodymium', '#b91919');
    registerExtraTierOres('azure_neodymium', '#1936b9');
    registerExtraTierOres('desh', '#c57041');
    registerExtraTierOres('ostrum', '#76525f');
    registerExtraTierOres('calorite', '#b63044');
    registerExtraTierOres('iron', '#e6c6af');
    registerExtraTierOres('copper', '#e67951');
    registerExtraTierOres('gold', '#f4c230');
    registerExtraTierOres('lead', '8b9cd0');
    registerExtraTierOres('aluminum', '#deeded');
    registerExtraTierOres('nickel', '#e1e0de');
    registerExtraTierOres('osmium', '#acc4c5');
    registerExtraTierOres('platinum', '#8ebfd8');
    registerExtraTierOres('silver', '#ddd8ca');
    registerExtraTierOres('tin', '#dff1f8');
    registerExtraTierOres('uranium', '#e2e44f');
    registerExtraTierOres('zinc', '#d5ede3');
    registerExtraTierOres('iridium', '#d1ccc6');
    registerExtraTierOres('allthemodium', '#fcf572');
    registerExtraTierOres('vibranium', '#26db86');
    registerExtraTierOres('unobtainium', '#a62be0');
});
