ServerEvents.recipes(function (event) {
    var registerTinkerMaterial = function (config) {
        var _a, _b, _c, _d, _e, _f, _g, _h;
        var material = config.material, fluid = config.fluid, ingot = config.ingot, block = config.block, nugget = config.nugget, gem = config.gem, dust = config.dust;
        var temperature = (_a = config.temperature) !== null && _a !== void 0 ? _a : 800;
        var time = (_b = config.time) !== null && _b !== void 0 ? _b : 60;
        var coolingTime = (_c = config.coolingTime) !== null && _c !== void 0 ? _c : time;
        var ingotAmount = (_d = config.ingotAmount) !== null && _d !== void 0 ? _d : 90;
        var blockAmount = (_e = config.blockAmount) !== null && _e !== void 0 ? _e : ingotAmount * 9;
        var nuggetAmount = (_f = config.nuggetAmount) !== null && _f !== void 0 ? _f : Math.floor(ingotAmount / 9);
        var gemAmount = (_g = config.gemAmount) !== null && _g !== void 0 ? _g : nuggetAmount * 10;
        var dustAmount = (_h = config.dustAmount) !== null && _h !== void 0 ? _h : ingotAmount;
        if (ingot) {
            // 锭熔炼
            event.custom({
                type: 'tconstruct:melting',
                ingredient: { item: ingot },
                result: { amount: ingotAmount, fluid: fluid },
                temperature: temperature,
                time: time,
            });
            // 锭浇筑（多用途）
            event.custom({
                type: 'tconstruct:casting_table',
                cast: { tag: 'tconstruct:casts/multi_use/ingot' },
                cooling_time: coolingTime,
                fluid: { amount: ingotAmount, fluid: fluid },
                result: ingot,
            });
            // 锭浇筑（单次）
            event.custom({
                type: 'tconstruct:casting_table',
                cast: { tag: 'tconstruct:casts/single_use/ingot' },
                cast_consumed: true,
                cooling_time: coolingTime,
                fluid: { amount: ingotAmount, fluid: fluid },
                result: ingot,
            });
            // 锭材料加工
            event.custom({
                type: 'tconstruct:material',
                ingredient: { item: ingot },
                material: material,
                needed: 1,
                value: 1,
            });
        }
        if (block) {
            // 块熔炼
            event.custom({
                type: 'tconstruct:melting',
                ingredient: { item: block },
                result: { amount: blockAmount, fluid: fluid },
                temperature: temperature,
                time: time * 9,
            });
            // 块材料加工
            event.custom({
                type: 'tconstruct:material',
                ingredient: { item: block },
                leftover: { count: 1, item: ingot },
                material: material,
                needed: 1,
                value: 9,
            });
            // 块浇筑
            event.custom({
                type: 'tconstruct:casting_basin',
                cooling_time: coolingTime * 9,
                fluid: { amount: blockAmount, fluid: fluid },
                result: block,
            });
        }
        if (nugget) {
            // 粒熔炼
            event.custom({
                type: 'tconstruct:melting',
                ingredient: { item: nugget },
                result: { amount: nuggetAmount, fluid: fluid },
                temperature: temperature,
                time: Math.floor(time / 9),
            });
            // 粒材料加工
            event.custom({
                type: 'tconstruct:material',
                ingredient: { item: nugget },
                material: material,
                needed: 9,
                value: 1,
            });
            // 粒浇筑（多用途）
            event.custom({
                type: 'tconstruct:casting_table',
                cast: { tag: 'tconstruct:casts/multi_use/nugget' },
                cooling_time: Math.floor(coolingTime / 9),
                fluid: { amount: nuggetAmount, fluid: fluid },
                result: nugget,
            });
            // 粒浇筑（单次）
            event.custom({
                type: 'tconstruct:casting_table',
                cast: { tag: 'tconstruct:casts/single_use/nugget' },
                cast_consumed: true,
                cooling_time: Math.floor(coolingTime / 9),
                fluid: { amount: nuggetAmount, fluid: fluid },
                result: nugget,
            });
        }
        if (gem) {
            event.custom({
                type: 'tconstruct:melting',
                ingredient: { item: gem },
                result: { amount: gemAmount, fluid: fluid },
                temperature: temperature,
                time: time,
            });
            event.custom({
                type: 'tconstruct:casting_table',
                cast: { tag: 'tconstruct:casts/multi_use/gem' },
                cooling_time: coolingTime,
                fluid: { amount: gemAmount, fluid: fluid },
                result: gem,
            });
            event.custom({
                type: 'tconstruct:casting_table',
                cast: { tag: 'tconstruct:casts/single_use/gem' },
                cast_consumed: true,
                cooling_time: coolingTime,
                fluid: { amount: gemAmount, fluid: fluid },
                result: gem,
            });
            event.custom({
                type: 'tconstruct:material',
                ingredient: { item: gem },
                material: material,
                needed: 9,
                value: 10,
            });
        }
        if (dust) {
            event.custom({
                type: 'tconstruct:melting',
                ingredient: { item: dust },
                result: { amount: dustAmount, fluid: fluid },
                temperature: temperature,
                time: Math.floor(time / 2),
            });
        }
        // 材料流体注册
        event.custom({
            type: 'tconstruct:material_fluid',
            fluid: { amount: ingotAmount, fluid: fluid },
            temperature: temperature,
            output: material,
        });
    };
    registerTinkerMaterial({
        material: 'kubejs:refined_glowstone',
        fluid: 'tconstruct:molten_refined_glowstone',
        ingot: 'mekanism:ingot_refined_glowstone',
        block: 'mekanism:block_refined_glowstone',
        nugget: 'mekanism:nugget_refined_glowstone',
        temperature: 825,
    });
    registerTinkerMaterial({
        material: 'kubejs:refined_obsidian',
        fluid: 'tconstruct:molten_refined_obsidian',
        ingot: 'mekanism:ingot_refined_obsidian',
        block: 'mekanism:block_refined_obsidian',
        nugget: 'mekanism:nugget_refined_obsidian',
        temperature: 1475,
    });
    registerTinkerMaterial({
        material: 'kubejs:fluix',
        fluid: 'kubejs:molten_fluix',
        gem: 'ae2:fluix_crystal',
        block: 'ae2:fluix_block',
        blockAmount: 900,
        dust: 'ae2:fluix_dust',
    });
    registerTinkerMaterial({
        material: 'kubejs:zanite',
        fluid: 'kubejs:molten_zanite',
        gem: 'aether:zanite_gemstone',
        block: 'aether:zanite_block',
        blockAmount: 900,
    });
    registerTinkerMaterial({
        material: 'kubejs:fiery',
        fluid: 'kubejs:molten_fiery',
        ingot: 'twilightforest:fiery_ingot',
        block: 'twilightforest:fiery_block',
    });
    registerTinkerMaterial({
        material: 'kubejs:brass',
        fluid: 'kubejs:molten_brass',
        ingot: 'create:brass_ingot',
        block: 'create:brass_block',
        nugget: 'create:brass_nugget',
        dust: 'alltheores:brass_dust',
    });
    registerTinkerMaterial({
        material: 'kubejs:ironwood',
        fluid: 'kubejs:molten_ironwood',
        ingot: 'twilightforest:ironwood_ingot',
        block: 'twilightforest:ironwood_block',
        dust: 'kubejs:ironwood_dust',
    });
    registerTinkerMaterial({
        material: 'kubejs:iridium',
        fluid: 'kubejs:molten_iridium',
        ingot: 'alltheores:iridium_ingot',
        block: 'alltheores:iridium_block',
        nugget: 'alltheores:iridium_nugget',
        dust: 'alltheores:iridium_dust',
        temperature: 1200,
    });
    registerTinkerMaterial({
        material: 'kubejs:desh',
        fluid: 'kubejs:molten_desh',
        ingot: 'ad_astra:desh_ingot',
        block: 'ad_astra:desh_block',
        nugget: 'ad_astra:desh_nugget',
        dust: 'kubejs:desh_dust',
    });
    registerTinkerMaterial({
        material: 'kubejs:ostrum',
        fluid: 'kubejs:molten_ostrum',
        ingot: 'ad_astra:ostrum_ingot',
        block: 'ad_astra:ostrum_block',
        nugget: 'ad_astra:ostrum_nugget',
        dust: 'kubejs:ostrum_dust',
    });
    registerTinkerMaterial({
        material: 'kubejs:calorite',
        fluid: 'kubejs:molten_calorite',
        ingot: 'ad_astra:calorite_ingot',
        block: 'ad_astra:calorite_block',
        nugget: 'ad_astra:calorite_nugget',
        dust: 'kubejs:calorite_dust',
        temperature: 1200,
    });
});
