ServerEvents.recipes(function (event) {
    var registerMekTier5Recipe = function (options) {
        var name = options.name, rawItem = options.rawItem, oreTag = options.oreTag, rawBlockTag = options.rawBlockTag;
        var rawIngredient = rawItem ? { item: rawItem } : { tag: "forge:raw_materials/".concat(name) };
        event.custom({
            type: 'mekanism:dissolution',
            gasInput: { amount: 1, gas: 'mekanism:sulfuric_acid' },
            itemInput: { amount: 3, ingredient: rawIngredient },
            output: { amount: 2000, chemicalType: 'slurry', slurry: "chemicaltweaker:dirty_".concat(name, "_slurry") },
        });
        if (oreTag) {
            var oreTagStr = typeof oreTag === 'string' ? oreTag : "forge:ores/".concat(name);
            event.custom({
                type: 'mekanism:dissolution',
                gasInput: { amount: 1, gas: 'mekanism:sulfuric_acid' },
                itemInput: { ingredient: { tag: oreTagStr } },
                output: { amount: 1000, chemicalType: 'slurry', slurry: "chemicaltweaker:dirty_".concat(name, "_slurry") },
            });
        }
        if (rawBlockTag) {
            var rawBlockTagStr = typeof rawBlockTag === 'string' ? rawBlockTag : "forge:storage_blocks/raw_".concat(name);
            event.custom({
                type: 'mekanism:dissolution',
                gasInput: { amount: 2, gas: 'mekanism:sulfuric_acid' },
                itemInput: { ingredient: { tag: rawBlockTagStr } },
                output: { amount: 6000, chemicalType: 'slurry', slurry: "chemicaltweaker:dirty_".concat(name, "_slurry") },
            });
        }
        event.custom({
            type: 'mekanism:washing',
            fluidInput: { amount: 5, tag: 'minecraft:water' },
            output: { amount: 1, slurry: "chemicaltweaker:clean_".concat(name, "_slurry") },
            slurryInput: { amount: 1, slurry: "chemicaltweaker:dirty_".concat(name, "_slurry") },
        });
        event.custom({
            type: 'mekanism:crystallizing',
            chemicalType: 'slurry',
            input: { amount: 200, slurry: "chemicaltweaker:clean_".concat(name, "_slurry") },
            output: { item: "kubejs:".concat(name, "_crystal") },
        });
    };
    registerMekTier5Recipe({ name: 'ironwood' });
    registerMekTier5Recipe({ name: 'cobalt', oreTag: true, rawBlockTag: true });
    registerMekTier5Recipe({ name: 'titanium', oreTag: true });
    registerMekTier5Recipe({ name: 'stellarium', oreTag: true });
    registerMekTier5Recipe({ name: 'immersed_silver', oreTag: true });
    registerMekTier5Recipe({ name: 'inert_witherium', oreTag: true });
    registerMekTier5Recipe({ name: 'hothium', oreTag: true });
    registerMekTier5Recipe({ name: 'magiga', oreTag: true });
    registerMekTier5Recipe({ name: 'tonium', oreTag: true });
    registerMekTier5Recipe({ name: 'scarlet_neodymium', rawItem: 'alexscaves:raw_scarlet_neodymium' });
    registerMekTier5Recipe({ name: 'azure_neodymium', rawItem: 'alexscaves:raw_azure_neodymium' });
    registerMekTier5Recipe({ name: 'desh', oreTag: true, rawBlockTag: true });
    registerMekTier5Recipe({ name: 'ostrum', oreTag: true, rawBlockTag: true });
    registerMekTier5Recipe({ name: 'calorite', oreTag: true, rawBlockTag: true });
});
