ServerEvents.recipes(function (event) {
    var registerMekTier1To4Recipes = function (options) {
        var name = options.name, rawItem = options.rawItem, oreTag = options.oreTag, rawBlockTag = options.rawBlockTag, ingotItem = options.ingotItem, ingotTag = options.ingotTag;
        var rawIngredient = rawItem ? { item: rawItem } : { tag: "forge:raw_materials/".concat(name) };
        event.custom({
            type: 'mekanism:injecting',
            chemicalInput: { amount: 1, gas: 'mekanism:hydrogen_chloride' },
            itemInput: { amount: 3, ingredient: rawIngredient },
            output: { count: 8, item: "kubejs:".concat(name, "_shard") },
        });
        event.custom({
            type: 'mekanism:injecting',
            chemicalInput: { amount: 1, gas: 'mekanism:hydrogen_chloride' },
            itemInput: { ingredient: { item: "kubejs:".concat(name, "_crystal") } },
            output: { item: "kubejs:".concat(name, "_shard") },
        });
        event.custom({
            type: 'mekanism:purifying',
            chemicalInput: { amount: 1, gas: 'mekanism:oxygen' },
            itemInput: { ingredient: rawIngredient },
            output: { count: 2, item: "kubejs:".concat(name, "_clump") },
        });
        event.custom({
            type: 'mekanism:purifying',
            chemicalInput: { amount: 1, gas: 'mekanism:oxygen' },
            itemInput: { ingredient: { item: "kubejs:".concat(name, "_shard") } },
            output: { item: "kubejs:".concat(name, "_clump") },
        });
        event.custom({
            type: 'mekanism:crushing',
            input: { ingredient: { item: "kubejs:".concat(name, "_clump") } },
            output: { item: "kubejs:".concat(name, "_dirty_dust") },
        });
        event.custom({
            type: 'mekanism:enriching',
            input: { amount: 3, ingredient: rawIngredient },
            output: { count: 4, item: "kubejs:".concat(name, "_dust") },
        });
        event.custom({
            type: 'mekanism:enriching',
            input: { ingredient: { item: "kubejs:".concat(name, "_dirty_dust") } },
            output: { item: "kubejs:".concat(name, "_dust") },
        });
        if (ingotItem) {
            event.custom({
                type: 'minecraft:smelting',
                cookingtime: 200,
                experience: 0.5,
                ingredient: { item: "kubejs:".concat(name, "_dust") },
                result: ingotItem,
            });
            event.custom({
                type: 'minecraft:blasting',
                cookingtime: 100,
                experience: 0.5,
                ingredient: { item: "kubejs:".concat(name, "_dust") },
                result: ingotItem,
            });
        }
        if (ingotTag || ingotItem) {
            var ingotTagStr = ingotTag
                ? typeof ingotTag === 'string'
                    ? ingotTag
                    : "forge:ingots/".concat(name)
                : undefined;
            var ingotIngredient = ingotTag ? { tag: ingotTagStr } : { item: ingotItem };
            event.custom({
                type: 'mekanism:crushing',
                input: { ingredient: ingotIngredient },
                output: { item: "kubejs:".concat(name, "_dust") },
            });
        }
        if (oreTag) {
            var oreTagStr = typeof oreTag === 'string' ? oreTag : "forge:ores/".concat(name);
            event.custom({
                type: 'mekanism:injecting',
                chemicalInput: { amount: 1, gas: 'mekanism:hydrogen_chloride' },
                itemInput: { ingredient: { tag: oreTagStr } },
                output: { count: 4, item: "kubejs:".concat(name, "_shard") },
            });
            event.custom({
                type: 'mekanism:purifying',
                chemicalInput: { amount: 1, gas: 'mekanism:oxygen' },
                itemInput: { ingredient: { tag: oreTagStr } },
                output: { count: 3, item: "kubejs:".concat(name, "_clump") },
            });
            event.custom({
                type: 'mekanism:enriching',
                input: { ingredient: { tag: oreTagStr } },
                output: { count: 2, item: "kubejs:".concat(name, "_dust") },
            });
        }
        if (rawBlockTag) {
            var rawBlockTagStr = typeof rawBlockTag === 'string' ? rawBlockTag : "forge:storage_blocks/raw_".concat(name);
            event.custom({
                type: 'mekanism:injecting',
                chemicalInput: { amount: 2, gas: 'mekanism:hydrogen_chloride' },
                itemInput: { ingredient: { tag: rawBlockTagStr } },
                output: { count: 24, item: "kubejs:".concat(name, "_shard") },
            });
            event.custom({
                type: 'mekanism:purifying',
                chemicalInput: { amount: 2, gas: 'mekanism:oxygen' },
                itemInput: { ingredient: { tag: rawBlockTagStr } },
                output: { count: 18, item: "kubejs:".concat(name, "_clump") },
            });
            event.custom({
                type: 'mekanism:enriching',
                input: { ingredient: { tag: rawBlockTagStr } },
                output: { count: 12, item: "kubejs:".concat(name, "_dust") },
            });
        }
    };
    registerMekTier1To4Recipes({
        name: 'ironwood',
        ingotItem: 'twilightforest:ironwood_ingot',
        ingotTag: true,
    });
    registerMekTier1To4Recipes({
        name: 'cobalt',
        oreTag: true,
        rawBlockTag: true,
        ingotItem: 'tconstruct:cobalt_ingot',
        ingotTag: true,
    });
    registerMekTier1To4Recipes({
        name: 'titanium',
        oreTag: true,
        ingotItem: 'tinkerscalibration:titanium_ingot',
        ingotTag: true,
    });
    registerMekTier1To4Recipes({
        name: 'stellarium',
        oreTag: true,
        ingotItem: 'tinkerscalibration:stellarium_ingot',
        ingotTag: true,
    });
    registerMekTier1To4Recipes({
        name: 'immersed_silver',
        oreTag: true,
        ingotItem: 'tinkerscalibration:immersed_silver_ingot',
        ingotTag: true,
    });
    registerMekTier1To4Recipes({
        name: 'inert_witherium',
        oreTag: true,
        ingotItem: 'tinkerscalibration:inert_witherium_ingot',
        ingotTag: true,
    });
    registerMekTier1To4Recipes({
        name: 'hothium',
        oreTag: true,
        ingotItem: 'tinkerscalibration:hothium_ingot',
        ingotTag: true,
    });
    registerMekTier1To4Recipes({
        name: 'magiga',
        oreTag: true,
        ingotItem: 'tinkerscalibration:magiga_ingot',
        ingotTag: true,
    });
    registerMekTier1To4Recipes({
        name: 'tonium',
        oreTag: true,
        ingotItem: 'tinkerscalibration:tonium_ingot',
        ingotTag: true,
    });
    registerMekTier1To4Recipes({
        name: 'scarlet_neodymium',
        rawItem: 'alexscaves:raw_scarlet_neodymium',
    });
    registerMekTier1To4Recipes({
        name: 'azure_neodymium',
        rawItem: 'alexscaves:raw_azure_neodymium',
    });
    registerMekTier1To4Recipes({
        name: 'desh',
        oreTag: true,
        rawBlockTag: true,
        ingotItem: 'ad_astra:desh_ingot',
        ingotTag: true,
    });
    registerMekTier1To4Recipes({
        name: 'ostrum',
        oreTag: true,
        rawBlockTag: true,
        ingotItem: 'ad_astra:ostrum_ingot',
        ingotTag: true,
    });
    registerMekTier1To4Recipes({
        name: 'calorite',
        oreTag: true,
        rawBlockTag: true,
        ingotItem: 'ad_astra:calorite_ingot',
        ingotTag: true,
    });
});
