ServerEvents.recipes(function (event) {
    var registerExtraOreRecipe = function (config) {
        var _a, _b;
        var name = config.name, raw = config.raw, molten = config.molten, byProduct = config.byProduct, missingRaw = config.missingRaw;
        var temperature = (_a = config.temperature) !== null && _a !== void 0 ? _a : 800;
        var byProductAmount = (_b = config.byProductAmount) !== null && _b !== void 0 ? _b : 162;
        event.custom({
            type: 'create:crushing',
            ingredients: [{ item: "kubejs:dense_".concat(name, "_shard") }],
            processingTime: 400,
            results: [
                { item: "kubejs:broken_".concat(name, "_shard"), count: 2 },
                { item: "kubejs:tiny_".concat(name, "_shard"), chance: 0.1 },
            ],
        });
        event.custom({
            type: 'integrateddynamics:mechanical_squeezer',
            item: "kubejs:broken_".concat(name, "_shard"),
            result: { items: [{ item: "kubejs:compressed_".concat(name, "_shard") }] },
            duration: 40,
        });
        event.custom({
            type: 'create:mixing',
            heatRequirement: 'heated',
            ingredients: [
                { item: "kubejs:compressed_".concat(name, "_shard") },
                { amount: 10, fluid: 'ad_astra:cryo_fuel', nbt: {} },
            ],
            results: [{ item: "kubejs:recrystallized_".concat(name, "_crystal") }],
        });
        event.custom({
            type: 'mekanism:injecting',
            chemicalInput: { amount: 1, gas: 'mekanism:hydrogen_chloride' },
            itemInput: { ingredient: { item: "kubejs:recrystallized_".concat(name, "_crystal") } },
            output: { item: "kubejs:crystallized_".concat(name, "_shard") },
        });
        event.custom({
            type: 'mekanism:purifying',
            chemicalInput: { amount: 1, gas: 'mekanism:oxygen' },
            itemInput: { ingredient: { item: "kubejs:crystallized_".concat(name, "_shard") } },
            output: { item: "kubejs:crystallized_".concat(name, "_clump") },
        });
        event.custom({
            type: 'advanced_ae:reaction',
            energy: 10000,
            fluid: { fluidStack: { Amount: 250, FluidName: 'industrialforegoing:latex' } },
            input_items: [{ amount: 32, ingredient: { item: "kubejs:crystallized_".concat(name, "_clump") } }],
            output: { '#': 1, '#c': 'ae2:i', id: "kubejs:crystallized_".concat(name, "_crumb") },
        });
        event.custom({
            type: 'ae2:inscriber',
            ingredients: {
                middle: { item: "kubejs:crystallized_".concat(name, "_crumb") },
            },
            mode: 'inscribe',
            result: { item: "kubejs:dense_crystallized_".concat(name, "_plate") },
        });
        event.custom({
            type: 'powah:energizing',
            ingredients: [{ item: "kubejs:dense_crystallized_".concat(name, "_plate") }],
            energy: 10000,
            result: { item: "kubejs:powered_crystallized_".concat(name, "_plate"), count: 1 },
        });
        event.custom({
            type: 'create:cutting',
            ingredients: [{ item: "kubejs:powered_crystallized_".concat(name, "_plate") }],
            processingTime: 20,
            results: [
                { item: "kubejs:".concat(name, "_crystal_fragment"), count: 32 },
                { item: "kubejs:powered_".concat(name, "_crystal_fragment"), chance: 0.1 },
            ],
        });
        event.custom({
            type: 'create:splashing',
            ingredients: [{ item: "kubejs:".concat(name, "_crystal_fragment") }],
            results: [
                { item: "kubejs:crystallized_".concat(name, "_dust") },
                { item: "kubejs:dense_".concat(name, "_crystal_fragment"), chance: 0.1 },
            ],
        });
        event.custom({
            type: 'mekanism:crushing',
            input: { ingredient: { item: "kubejs:crystallized_".concat(name, "_dust") } },
            output: { item: "kubejs:dirty_".concat(name, "_smooth_dust") },
        });
        event.custom({
            type: 'mekanism:enriching',
            input: { ingredient: { item: "kubejs:dirty_".concat(name, "_smooth_dust") }, amount: 2 },
            output: { item: "kubejs:".concat(name, "_smooth_dust"), count: 3 },
        });
        event.custom({
            type: 'tconstruct:ore_melting',
            byproducts: [{ amount: byProductAmount, fluid: byProduct }],
            rate: 'metal',
            result: { amount: 90, fluid: molten },
            ingredient: { item: "kubejs:".concat(name, "_smooth_dust") },
            temperature: temperature,
            time: 30,
        });
        event.custom({
            type: 'minecraft:smelting',
            ingredient: { item: "kubejs:".concat(name, "_smooth_dust") },
            result: { item: "kubejs:sintered_".concat(name, "_dust") },
            experience: 0.7,
            cookingtime: 200,
        });
        event.custom({
            type: 'minecraft:blasting',
            ingredient: { item: "kubejs:".concat(name, "_smooth_dust") },
            result: { item: "kubejs:sintered_".concat(name, "_dust") },
            experience: 0.7,
            cookingtime: 100,
        });
        event.custom({
            type: 'tconstruct:melting',
            ingredient: { item: "kubejs:sintered_".concat(name, "_dust") },
            result: { amount: 144, fluid: molten },
            temperature: temperature,
            time: 30,
        });
        if (missingRaw) {
            event.custom({
                type: 'tconstruct:ore_melting',
                byproducts: [{ amount: 30, fluid: byProduct }],
                rate: 'metal',
                result: { amount: 90, fluid: molten },
                ingredient: { item: raw },
                temperature: temperature,
                time: 75,
            });
        }
    };
    registerExtraOreRecipe({
        name: 'ironwood',
        raw: 'twilightforest:raw_ironwood',
        molten: 'kubejs:molten_ironwood',
        byProduct: 'minecraft:lava',
        missingRaw: true,
        byProductAmount: 164,
    });
    registerExtraOreRecipe({
        name: 'cobalt',
        raw: 'tconstruct:ore_cobalt',
        molten: 'tconstruct:molten_cobalt',
        byProduct: 'tconstruct:molten_diamond',
        temperature: 950,
    });
    registerExtraOreRecipe({
        name: 'titanium',
        raw: 'tconstruct:ore_titanium',
        molten: 'tinkerscalibration:moltentitanium',
        byProduct: 'tconstruct:molten_iron',
        temperature: 1350,
    });
    registerExtraOreRecipe({
        name: 'stellarium',
        raw: 'tinkerscalibration:raw_stellarium',
        molten: 'tinkerscalibration:moltenstellarium',
        byProduct: 'tconstruct:molten_iron',
        temperature: 1260,
    });
    registerExtraOreRecipe({
        name: 'immersed_silver',
        raw: 'tinkerscalibration:raw_immersed_silver',
        molten: 'tinkerscalibration:moltenimmersedsilver',
        byProduct: 'tconstruct:molten_iron',
        temperature: 1090,
    });
    registerExtraOreRecipe({
        name: 'inert_witherium',
        raw: 'tinkerscalibration:raw_inert_witherium',
        molten: 'tinkerscalibration:molteninertwitherium',
        byProduct: 'tconstruct:molten_gold',
        temperature: 1130,
    });
    registerExtraOreRecipe({
        name: 'hothium',
        raw: 'tinkerscalibration:raw_hothium',
        molten: 'tinkerscalibration:moltenhothium',
        byProduct: 'tconstruct:molten_iron',
        temperature: 1070,
    });
    registerExtraOreRecipe({
        name: 'magiga',
        raw: 'tinkerscalibration:raw_magiga',
        molten: 'tinkerscalibration:moltenmagiga',
        byProduct: 'tinkerscalibration:moltensteamium',
        temperature: 1240,
    });
    registerExtraOreRecipe({
        name: 'tonium',
        raw: 'tinkerscalibration:raw_tonium',
        molten: 'tinkerscalibration:moltentonium',
        byProduct: 'tinkerscalibration:moltenhalleium',
        temperature: 1220,
    });
    registerExtraOreRecipe({
        name: 'scarlet_neodymium',
        raw: 'alexscaves:raw_scarlet_neodymium',
        molten: 'kubejs:molten_scarlet_neodymium',
        byProduct: 'kubejs:molten_azure_neodymium',
        missingRaw: true,
    });
    registerExtraOreRecipe({
        name: 'azure_neodymium',
        raw: 'alexscaves:raw_azure_neodymium',
        molten: 'kubejs:molten_azure_neodymium',
        byProduct: 'kubejs:molten_scarlet_neodymium',
        missingRaw: true,
    });
    registerExtraOreRecipe({
        name: 'desh',
        raw: 'ad_astra:raw_desh',
        molten: 'kubejs:molten_desh',
        byProduct: 'tconstruct:molten_osmium',
        missingRaw: true,
    });
    registerExtraOreRecipe({
        name: 'ostrum',
        raw: 'ad_astra:raw_ostrum',
        molten: 'kubejs:molten_ostrum',
        byProduct: 'kubejs:molten_iridium',
        missingRaw: true,
    });
    registerExtraOreRecipe({
        name: 'calorite',
        raw: 'ad_astra:raw_calorite',
        molten: 'kubejs:molten_calorite',
        byProduct: 'tconstruct:molten_platinum',
        missingRaw: true,
        temperature: 1200,
    });
    registerExtraOreRecipe({
        name: 'iron',
        raw: 'minecraft:raw_iron',
        molten: 'tconstruct:molten_iron',
        byProduct: 'tconstruct:molten_steel',
    });
    registerExtraOreRecipe({
        name: 'copper',
        raw: 'minecraft:raw_copper',
        molten: 'tconstruct:molten_copper',
        byProduct: 'tconstruct:molten_gold',
        temperature: 500,
    });
    registerExtraOreRecipe({
        name: 'gold',
        raw: 'minecraft:raw_gold',
        molten: 'tconstruct:molten_gold',
        byProduct: 'tconstruct:molten_cobalt',
        temperature: 700,
    });
    registerExtraOreRecipe({
        name: 'aluminum',
        raw: 'alltheores:raw_aluminum',
        molten: 'tconstruct:molten_aluminum',
        byProduct: 'tconstruct:molten_iron',
        temperature: 425,
    });
    registerExtraOreRecipe({
        name: 'lead',
        raw: 'alltheores:raw_lead',
        molten: 'tconstruct:molten_lead',
        byProduct: 'tconstruct:molten_silver',
        temperature: 330,
    });
    registerExtraOreRecipe({
        name: 'nickel',
        raw: 'alltheores:raw_nickel',
        molten: 'tconstruct:molten_nickel',
        byProduct: 'tconstruct:molten_platinum',
        temperature: 950,
    });
    registerExtraOreRecipe({
        name: 'osmium',
        raw: 'alltheores:raw_osmium',
        molten: 'tconstruct:molten_osmium',
        byProduct: 'tconstruct:molten_iron',
        temperature: 975,
    });
    registerExtraOreRecipe({
        name: 'platinum',
        raw: 'alltheores:raw_platinum',
        molten: 'tconstruct:molten_platinum',
        byProduct: 'tconstruct:molten_gold',
        temperature: 970,
    });
    registerExtraOreRecipe({
        name: 'silver',
        raw: 'alltheores:raw_silver',
        molten: 'tconstruct:molten_silver',
        byProduct: 'tconstruct:molten_lead',
        temperature: 790,
    });
    registerExtraOreRecipe({
        name: 'tin',
        raw: 'alltheores:raw_tin',
        molten: 'tconstruct:molten_tin',
        byProduct: 'tconstruct:molten_nickel',
        temperature: 225,
    });
    registerExtraOreRecipe({
        name: 'uranium',
        raw: 'alltheores:raw_uranium',
        molten: 'tconstruct:molten_uranium',
        byProduct: 'tconstruct:molten_lead',
        temperature: 830,
    });
    registerExtraOreRecipe({
        name: 'zinc',
        raw: 'alltheores:raw_zinc',
        molten: 'tconstruct:molten_zinc',
        byProduct: 'tconstruct:molten_tin',
        temperature: 420,
    });
    registerExtraOreRecipe({
        name: 'iridium',
        raw: 'alltheores:raw_iridium',
        molten: 'kubejs:molten_iridium',
        byProduct: 'tconstruct:molten_osmium',
        missingRaw: true,
        temperature: 1200,
    });
    registerExtraOreRecipe({
        name: 'allthemodium',
        raw: 'allthemodium:raw_allthemodium',
        molten: 'allthemodium:molten_allthemodium',
        byProduct: 'tconstruct:molten_diamond',
        temperature: 1500,
    });
    registerExtraOreRecipe({
        name: 'vibranium',
        raw: 'allthemodium:raw_vibranium',
        molten: 'allthemodium:molten_vibranium',
        byProduct: 'allthemodium:molten_allthemodium',
        temperature: 5000,
    });
    registerExtraOreRecipe({
        name: 'unobtainium',
        raw: 'allthemodium:raw_unobtainium',
        molten: 'allthemodium:molten_unobtainium',
        byProduct: 'allthemodium:molten_vibranium',
        temperature: 9000,
    });
});
